/*
 * MulticastQuoteReceiver.java
 *
 * Created on November 1, 2004, 10:45 AM
 */

package udp;

import java.io.*;
import java.net.*;
import java.util.*;

/**
 *
 * @author  garbi
 */

public class MulticastQuoteReceiver {
    public static void main(String[] args) throws Exception {
        try {
            System.setProperty("java.net.preferIPv4Stack", "true");
            MulticastSocket socket=null;
            //create a multicast socket on port 4446
            socket=new MulticastSocket(4446);
           InetAddress group=null;
           //create a group address using "224.0.0.1" as String address (use a static method provided by InetAddress to create the address)
           group=InetAddress.getByName("224.0.0.1");
           //associate the socket with the group (join the group)
           socket.joinGroup(group);
        while (true) {
            byte[] buf = new byte[256];
            DatagramPacket packet=null; 
            //create a datagram for receiving packet with buf as data template
            //***************************************************
            System.out.print("Waiting for the next quote: ");
            //receive the packet on the socket
            //***************************************************
            String received = new String(packet.getData());
            System.out.println(received);
            if ( received.indexOf("bye") != -1 ) break;
        }
        socket.leaveGroup(group);
        socket.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
